/*! \file 
**********************************************************************************
*Title:                         Discretix OMA DRM v2 Toolkit Test source file
*
* Filename:                     ODRM_TLK_ATP_data.c
*
* Project, Target, subsystem:   Toolkit, OMA DRM
* 
* Created:                      06.12.2007
*
* \Author                       SagitB
*
* \Remarks
*           Copyright (C) 2007 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#include "DX_VOS_BaseTypes.h"
#include "ODRM_SecROHandling_data.h"
#include "DX_VOS_Utils.h"
#include "DX_VOS_Mem.h"
#include "DX_VOS_String.h"
#include "MW_ATP_UTIL_funcs.h"
#include "DX_VOS_File.h"

//const DxChar_t*				RegistrationOCSPResp = "MIIEawoBAKCCBGQwggRgBgkrBgEFBQcwAQEEggRRMIIETTCBtqFQME4xDTALBgNVBAMTBE9sYWYxHjAcBgNVBAoTFU9sYWYgKE9DU1AgUmVzcG9uZGVyKTEQMA4GA1UEBxMHSGFtYnVyZzELMAkGA1UEBhMCREUYDzIwMDkwMzAyMDkxNjQ5WjBRME8wOjAJBgUrDgMCGgUABBR5YyPfYNQSIT/keFmRlJEpqGd94wQUBpuLnJ/cKa/XaQJnad+K4bK6obkCAQuAABgPMjAwOTAzMDIwOTE2NDlaMA0GCSqGSIb3DQEBBQUAA4GBACDjPXnR/9T6Z/USA0Uo+N1UqUctWPyKumG3ek9EbUEGDPaFHgpZ9rWTDptr2DC90qq8ZycRMtWJV291xqKZiwCxVZai+P+zie0qh4y628wjfEn2xQ0ILFlHXkltImI5lcxXef0K45KeV0WrfDd+9LJfXd5trpr/KWVQsa7YoSn/oIIC/TCCAvkwggL1MIIB3aADAgECAgEPMA0GCSqGSIb3DQEBBQUAMDMxDTALBgNVBAMTBEJldGgxFTATBgNVBAoTDEJldGggKFJJIENBKTELMAkGA1UEBhMCREUwIBcNMDUwMTAxMDAwMDAwWhgPMjA5OTEyMzEyMjU5NTlaME4xDTALBgNVBAMTBE9sYWYxHjAcBgNVBAoTFU9sYWYgKE9DU1AgUmVzcG9uZGVyKTEQMA4GA1UEBxMHSGFtYnVyZzELMAkGA1UEBhMCREUwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAL32YxSIFO1R64OytbJLvH2pd0sDdE1a504C+AvCkRkI9y1bnZkp5n+812PiRFqTi2oE/oIwTW4UKqb204vxdaK2PZs+PeN3ugd0zR8QWi5r3bH1fThJNoWvpFfBTHSCqY6SxFpFNwf7ZEgu46EP2AKqskk99RPdXwO6K5mmuONJAgMBAAGjezB5MA4GA1UdDwEB/wQEAwIHgDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCTAfBgNVHSMEGDAWgBQGm4ucn9wpr9dpAmdp34rhsrqhuTAdBgNVHQ4EFgQUD41EsTyrCNo3H4DvP+hhNKKE5o8wDwYJKwYBBQUHMAEFBAIFADANBgkqhkiG9w0BAQUFAAOCAQEANyFD2yrpW6c8q5hXPfeg0rI5QUfBbN1RbDlMtBOnTXUZy9T4IRQN9Q+XdR7obqrbmjkxZV2RI3bIUEBQJlcX0fHDtYi3zpyOoZyoFeZhtbvOct433PWf05ZXNnl4cRVLdxTIt7YuykifJocLx+VfI2tmzF/5O9RwOKZx4wYi5TDQMgBININU5LM0EgJxoacMluVChnGwoGtgJExMvcEdAkyqhilacz83dT/DvcluRyE5RwKA+Iryl2TaIDYTwYa2s8IvKu86pbo8t5OMPVXiiWBJcffp/E/F1G8MBUq9xioN+IqbJ9mJ2Fc86mDO7HztTA0nHD8LfceaL2q+2kwdGg==";
//const DxChar_t*				RICert ="MIICtDCCAZygAwIBAgIBCzANBgkqhkiG9w0BAQUFADAzMQ0wCwYDVQQDEwRCZXRoMRUwEwYDVQQKEwxCZXRoIChSSSBDQSkxCzAJBgNVBAYTAkRFMB4XDTA1MDEwMTAwMDAwMFoXDTA5MTIzMTIyNTk1OVowQjENMAsGA1UEAxMEUmljazESMBAGA1UEChMJUmljayAoUkkpMRAwDgYDVQQHEwdIYW1idXJnMQswCQYDVQQGEwJERTCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEA1hnpJWMxzQJh2hDRdaOd+EZcPrZJo/45HKx0tsgkf3tuGE5rB+WuT9XcuL3NNp0uFftWXCJfhIi7YuA+jP+AGKtDNinpxzzzVw6UuPrA0uctOEm9esUzYbvULmoUWhSqnesPqGZB7NnSZXkVxfu8e/9aNNvv/d2AqathaDintHcCAwEAAaNIMEYwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQEB/wQJMAcGBWcrBgEBMB8GA1UdIwQYMBaAFAabi5yf3Cmv12kCZ2nfiuGyuqG5MA0GCSqGSIb3DQEBBQUAA4IBAQBkOv/D6uK38nQ4knhIS/i/oc3hGq6HQN15nTSpBwKvOua3PrO8a2dVtFDzMA0JWEWwhBWPr+cJoHx3fOLhnEWTJmkHrQIWa3/wn5krgJYbOq1W6sf6tCR9jFWtpokrNrro1zpA/E310VYX0d0LHXPuUPcMQKmqTYnUq9dDxyHTUStl4JnpoUm8vm67nZW5/wv6VhEK++RdMNdjSobT3hLc9u9IbhVIp2vcw/CrubOnwn/ZJK6jkXPKkv18XFClZrQR46je2oP7SjLCpw84xLTNN4jLSAEvavt+/J5vZntYDEc1AE9+yeyZPwcgtMIcyAzZXic3TMPvRlggsr/bQyls";
//const DxChar_t*				CACert ="MIIDSDCCAjCgAwIBAgIBAjANBgkqhkiG9w0BAQUFADA1MQ0wCwYDVQQDEwRBZGFtMRcwFQYDVQQKEw5BZGFtIChSb290IENBKTELMAkGA1UEBhMCREUwIBcNMDUwMTAxMDAwMDAwWhgPMjA5OTEyMzEyMjU5NTlaMDMxDTALBgNVBAMTBEJldGgxFTATBgNVBAoTDEJldGggKFJJIENBKTELMAkGA1UEBhMCREUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCxXRN/w9m9r+zo+UbQT0wuEJpDuIiHaL2W392dsa2bE70efopQ+NNAvItuVqLZipVmhJQMsgkZY4rNTHqXWxzLv3zi+JBihzVMafmHozWfinicNjiHuUZzDdLHVofXMVtHbcGSZgocNmhjfCs8zyyiLkcYPg3AuKvGjUfOq843Fyj21yy9oOsmRX+R6vlJAwd2yFQtHzQekZDxb+/5KSATBaWB8R9tWLHpLN/uwEmGh9QmlhDVsPJmdVJPqYT1sqaBIYiOTDgsCrnHvVciJuDyuPS8wmSnyxFYpjkRrAUm7IteoI9z8rtFTOhHVC1WUZncjxHap8MjEFIywvhvClthAgMBAAGjYzBhMA4GA1UdDwEB/wQEAwIBBjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQGm4ucn9wpr9dpAmdp34rhsrqhuTAfBgNVHSMEGDAWgBQ/NWWW3VJ5GsGztn9n3o3okLQP1zANBgkqhkiG9w0BAQUFAAOCAQEAcoYBDplwq7nPMpJiVomcHvDRAxhnOENckX3osh5Q3daRloJc6EmVHzOKqXB6cKUFTnxAl3RRvNREx70ZIc+J2K6/oAECF2UWJY+E0e6RPZaiSuHG8yiHVWELsVaAcAwitSGHc+QDWOzApHnXtV2bj/HNhiWRFrqF6cQMJodHE7fdjFyGjEokD/h1sfn+/+yIqBLUomWlUd9ERLaNTXGnph7gNaY/hp1zOm+rgQ89x4ZgRYwpQmBEupOn8CpkoDxqeT4v98vcbqzczlEd+LyHHWXn6zdXOoYcF5538HgYXDv/+7b6HwXTT2rwHhvpiyHqyLrSleXG4dP7LrGug0/aPg==";
//const DxChar_t*				RegistrationRequestClientNonce = "9C29F9E4E69C859A075C09127381B9AA8F8BFF8432303038303531333137333534353030EC73BA6E63B79C957F54EFBE87082F916C36CF360000000000000000000000000000000000000000000000000000000000000000000000000000000000000000CDCDCDCDCDCDCDCDCDCDCDCDCDCDCDCD";


DxUint8_t  TST_gKeyRingDomain[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];
DxUint8_t  TST_gKeyRingDevice[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];
DxUint8_t  TST_gKeyRingKmacKrec[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];
DxUint8_t  TST_gParentKeyRingKmacKrec[ODRMTLK_ATP_MAX_SIZE_KEY_RING_BUF];

DxUint8_t TST_gGroupIDKey[48] = {0x36,0x0c,0x5a,0xf9,0x4c,0x37,0x00,0x0c,0x9c,0x0a,0x9d,0x53,0x7e,0x03,0x63,0x91,0x29,0x73,0x6e,0x76,0x18,0xa8,0x78,0xda,0x6f,0xe2,0x3a,0x55,0x5c,0xdf,0x3f,0xbf,0xd1,0x2f,0x9e,0x91,0x04,0xfe,0x61,0x2b,0x42,0x4b,0xa1,0xfa,0xcf,0xef,0x3f,0xd3};

DxUint8_t TST_gInvalidGroupIDKey[48] = {0x37,0x0C,0x5A,0xf9,0x4c,0x37,0x00,0x0c,0x9c,0x0a,0x9d,0x53,0x7e,0x03,0x63,0x91,0x29,0x73,0x6e,0x76,0x18,0xa8,0x78,0xda,0x6f,0xe2,0x3a,0x55,0x5c,0xdf,0x3f,0xbf,0xd1,0x2f,0x9e,0x91,0x04,0xfe,0x61,0x2b,0x42,0x4b,0xa1,0xfa,0xcf,0xef,0x3f,0xd3};

DxByte_t* TST_RiIDKey = "I94/ovDhizE5m/K6t5f1holSdLM=";
DxByte_t* TST_InvRiIDKey = "I94/ovdhizE5m/K6t5f1holSdLM=";
DxUint32_t RO_TST_gWorkspaceSizeInBytes = 0;
DxByte_t   RO_TST_gWorkspace[25000];

CRYS_AES_IvCounter_t  IvCounter = {0};


const char* ServiceTimeString = "20090302091649Z0";

DxUint8_t  PrivExponent[PRIV_EXP_SIZE] = /*PrivetExponent_D*/
{0xa5, 0x91, 0xea, 0x1f, 0x87, 0x4b, 0x3d, 0x56, 0xdb, 0x1e, 0x4c, 0xc5, 0x9d, 0x6d, 0xba, 0xb8,
0x6d, 0x0b, 0xce, 0x66, 0x3f, 0xc6, 0x2d, 0xde, 0xe5, 0x99, 0x66, 0x7e, 0xf0, 0x95, 0x2a, 0x60,
0x85, 0xb0, 0x7f, 0x83, 0x5a, 0x85, 0x66, 0x4d, 0xcb, 0x6e, 0x71, 0xbb, 0x6c, 0xbb, 0x13, 0x7a,
0xb5, 0x86, 0x54, 0xa9, 0xb0, 0x59, 0x63, 0x42, 0x33, 0x7d, 0x25, 0x26, 0xce, 0xbd, 0x6d, 0x11,
0x89, 0xd5, 0x2d, 0xd1, 0xcb, 0x4c, 0x71, 0x74, 0x53, 0xf4, 0x5b, 0x90, 0x6f, 0xb2, 0x62, 0x3f,
0xce, 0x9c, 0x37, 0x8b, 0x5e, 0xec, 0x5e, 0xc2, 0x79, 0xb8, 0x26, 0xaa, 0x2e, 0x4e, 0xc9, 0x33,
0x9c, 0x37, 0x9a, 0xc3, 0xa0, 0x60, 0x20, 0x73, 0x29, 0xef, 0xc3, 0xb7, 0x88, 0xe8, 0xb5, 0x68,
0xc7, 0x07, 0x07, 0x7e, 0x41, 0x5c, 0x12, 0x7c, 0xdd, 0xf9, 0x6e, 0xb5, 0x1f, 0xa5, 0x54, 0x61};


DxUint8_t   PrivModulus[MODULUS_SIZE] = /* Modulus_N */
{0xae, 0xf7, 0xae, 0x56, 0xee, 0x61, 0x93, 0xf2, 0xcf, 0x22, 0x72, 0x66, 0x78, 0xc9, 0xb4, 0xd2,
0xc5, 0x06, 0x90, 0xb0, 0xff, 0x30, 0x46, 0x3a, 0x70, 0xcc, 0xdc, 0x1e, 0x18, 0xca, 0xe8, 0x22,
0xa4, 0x40, 0xdc, 0xcf, 0x1d, 0x08, 0xdd, 0xb2, 0xac, 0xd1, 0xd5, 0x90, 0x8c, 0x71, 0x05, 0xd4,
0xf3, 0x3c, 0x98, 0x1f, 0x18, 0x74, 0x39, 0x3a, 0x3e, 0x5e, 0xb0, 0x3c, 0x83, 0xbb, 0x03, 0x85,
0xf6, 0xdf, 0x60, 0xf7, 0x5e, 0x2f, 0x6d, 0x1b, 0x71, 0x15, 0xd2, 0x37, 0x58, 0xf0, 0x50, 0x73,
0xc9, 0xe4, 0x33, 0x54, 0xf6, 0xbc, 0xb8, 0xe5, 0xb5, 0xf4, 0xb5, 0xbe, 0x8a, 0x7e, 0x8a, 0xb8,
0x35, 0x57, 0xbe, 0x1d, 0xb6, 0x2b, 0xc6, 0x81, 0x9c, 0x68, 0xf7, 0x17, 0xb5, 0x06, 0x83, 0x23,
0x1f, 0xd7, 0x10, 0xd0, 0x81, 0x4b, 0x7c, 0x97, 0x2e, 0x71, 0xb3, 0xa7, 0xba, 0x88, 0xfc, 0xfb};

// the domain key: extracted from the join domain response.
DxUint8_t SecretDomainKey[16] = { 0x07, 0x65, 0xc1, 0xd5, 0xc6, 0x1b, 0x29, 0x2c, 0x52, 0x81, 0xda, 0xb0, 0xef, 0x55, 0xe9, 0xca};
DxUint8_t InvSecretDomainKey[16] = { 0x07, 0x65, 0xc1, 0xd5, 0xc6, 0x1b, 0x29, 0x2c, 0x52, 0x81, 0xda, 0xb0, 0xef, 0x55, 0xe9, 0xcb};

DxUint8_t   PubExponent[PUB_EXP_SIZE] =  {0x01,0x00,0x01};

DxUint8_t TST_PlainBuff[TEMP_BUFF_LEN] = {0x5F,0x98,0xB4,0x23,0x36,0x9C,0x11,0xB4,0x05,0x3F,0xDD,0x3D,0x78,0x78,0xD7,0x3A};
DxUint8_t TST_EncryptBuff[TEMP_BUFF_LEN] = {0x35,0xE1,0x0B,0xD5,0xB5,0x34,0x48,0x25,0xEC,0x0A,0xDA,0xFC,0x79,0x5A,0x0A,0x89};

DxUint8_t TST_PlainBuffCid6093[TEMP_BUFF_LEN] = {0x5F,0x98,0xB4,0x23,0x36,0x9C,0x11,0xB4,0x05,0x3F,0xDD,0x3D,0x78,0x78,0xD7,0x3A};
DxUint8_t TST_EncryptBuffCid6093[TEMP_BUFF_LEN] = {0x35,0xE1,0x0B,0xD5,0xB5,0x34,0x48,0x25,0xEC,0x0A,0xDA,0xFC,0x79,0x5A,0x0A,0x89};

DxUint8_t TST_PlainBuffCid61331[TEMP_BUFF_LEN] = {0x5F,0x98,0xB4,0x23,0x36,0x9C,0x11,0xB4,0x05,0x3F,0xDD,0x3D,0x78,0x78,0xD7,0x3A};
DxUint8_t TST_EncryptBuffCid61331[TEMP_BUFF_LEN] = {0x92,0x41,0x2A,0x85,0xA3,0x13,0xF1,0xC1,0x49,0xC4,0xD8,0xC3,0x90,0xBE,0x13,0x90};

DxUint8_t TST_PlainBuffCid61211[TEMP_BUFF_LEN] = {0x5F,0x98,0xB4,0x23,0x36,0x9C,0x11,0xB4,0x05,0x3F,0xDD,0x3D,0x78,0x78,0xD7,0x3A};
DxUint8_t TST_EncryptBuffCid61211[TEMP_BUFF_LEN] = {0x28,0xA4,0xBB,0x39,0x7B,0x0D,0x83,0x46,0x4F,0xF5,0x2D,0xED,0xE0,0x9A,0x7F,0x3C};

DxUint8_t TST_PlainBuffCid6051[TEMP_BUFF_LEN] = {0x5F,0x98,0xB4,0x23,0x36,0x9C,0x11,0xB4,0x05,0x3F,0xDD,0x3D,0x78,0x78,0xD7,0x3A};
DxUint8_t TST_EncryptBuffCid6051[TEMP_BUFF_LEN] = {0x97,0xF3,0xD0,0x9C,0x50,0x5D,0x17,0xE3,0x7B,0xE6,0x77,0xAA,0x5D,0x57,0x82,0xDC};

DxUint8_t TST_DataoutBuff[TEMP_BUFF_LEN];

const DxChar_t* DomainXML = "<roap:domainKey xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\"><encKey Id=\"DomainA000\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>WE919O31qha0G1HPoDH2LNrSncEXg1jk9yJKF2kvkI34IF2r/u7TOyWlKgIv/2tbSmvCccW1fzKfc1hsj4AO4Jt4jaVG3uxgT8kghOlND2ao6OMrXgDBY5Q6ZIfbPdCaMpgS3I+7V0XnkMSVQcp3GomsL2VR9UnVYjiDBi01FrYLYZyECyp3AWE9c+6NPt8gZhu0fdX2VdalyIv5VnnwhoLTYSN6xQoZ</xenc:CipherValue></xenc:CipherData></encKey><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><mac>ydXFF/oEWAa3o8EHvtddCK5Xulk=</mac></roap:domainKey>";
const DxChar_t* DomainRoXml = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" domainRO=\"true\" id=\"offer6131.1.xnx3fhFob3WiqZ4X_jpg\" riURL=\"http://qa-lab7.discretix.com:8080/iop-server/trigger/joindomain.cm?domain=DomainA000\" version=\"1.0\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6131.1.xnx3fhFob3WiqZ4X_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.0</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6131.1.xnx3fhFob3WiqZ4X_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid61331_jpg</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">N9cpjjsvp3mVcAujlHmNEEQ2kMU=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>CvTmTsE+rxW7iwo29Ep1grgsDkaLNOKO</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><signature><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsa-pss-default\"></ds:SignatureMethod><ds:Reference URI=\"#RELoffer6131.1.xnx3fhFob3WiqZ4X_jpg_0\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>5HRPHBAFZ4eXccUNHklfA8X8H5g=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">JOWauWmq++6o26S6Vrhkpulk6toTD+l8LXt7pHv0icWmJep82vyxjRdhTEsr2sig1J9iqyCOssV2f8iszOHhe2sSkuGiMjgY45v4YQF4cA6TScUuvMfJx46FLLDQ+HYKa+lYrWcU/gLxg1WeAVyHmxM+iJ3kpaWzQD9CJ9XtAp0=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></roap:X509SPKIHash></ds:KeyInfo></signature><timeStamp>2009-03-02T09:40:01Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:domainID>DomainA000</roap:domainID></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>xzLHto+k9VVR3d24GtTw0C2C23nlyDw+hUAnuLt0Nn7RgMBK0A0h3A==</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6131.1.xnx3fhFob3WiqZ4X_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>M8gYJ4/j8TQc70m8r4C1eJGV4Zo=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">kDvUftlbv8cPJfFdpFyAHwuRbRc=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* DomainRightsXmlStr = "<rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6131.1.xnx3fhFob3WiqZ4X_jpg_0\">    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.0</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6131.1.xnx3fhFob3WiqZ4X_jpg</o-dd:uid></o-ex:context>    <o-ex:agreement>      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid61331_jpg</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">N9cpjjsvp3mVcAujlHmNEEQ2kMU=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>CvTmTsE+rxW7iwo29Ep1grgsDkaLNOKO</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>      <o-ex:permission>        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">        </o-dd:display>      </o-ex:permission>    </o-ex:agreement>  </rights>";
const DxChar_t* RightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6093-2.1.faQAtIqXh6jzg03l_jpg\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6093-2.1.faQAtIqXh6jzg03l_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6093-2.1.faQAtIqXh6jzg03l_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid6093_jpg</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">Y6NHh4Y9GJKYM0jgEOb2CMinsxI=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>0XwT2hGDyxWR5LIHqjYhHsO5jgEEj5pd</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:datetime>\n              <o-dd:start>2005-01-01T00:00:00Z</o-dd:start>		\n              <o-dd:end>2012-12-31T23:59:59Z</o-dd:end>\n            </o-dd:datetime>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-16T08:04:12Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>Wnnihf3AR6oAlyFTK1K3+YRECsAX5fzWrigU/UPKi4jlyJYBk+dChMX31ArMWBWvRXNM9HnioN0KwGgZ2EnMA/kt0gusRRZvV3UpyTR1pina+t5a6woCR7nyXxauNEYHSBqLBfckq5SPu2qVJ7OKV40jlXJ5i35cMmf40BQfMRAo8mDk+T1Oinf5PUjYet8MDUICLJR7Kt2H5E/cO9QFDu3BC5WLrxOR</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6093-2.1.faQAtIqXh6jzg03l_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>ap+RMlXW/l5YYQBMP27F07q4XtY=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">oDdstjQbMtVROb7kOabkDmIMyVk=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";
const DxChar_t* InvalidKeyDomainXML = "<roap:domainKey xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\"><encKey Id=\"DomainA000\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>WE919O31qha0G1HPoDH2LNrSncEXg1jk9yJKF2kvkI34IF2r/u7TOyWlKgIv/2tbSmvCcCW1fzKfc1hsj4AO4Jt4jaVG3uxgT8kghOlND2ao6OMrXgDBY5Q6ZIfbPdCaMpgS3I+7V0XnkMSVQcp3GomsL2VR9UnVYjiDBi01FrYLYZyECyp3AWE9c+6NPt8gZhu0fdX2VdalyIv5VnnwhoLTYSN6xQoZ</xenc:CipherValue></xenc:CipherData></encKey><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><mac>ydXFF/oEWAa3o8EHvtddCK5Xulk=</mac></roap:domainKey>";
const DxChar_t* ChildRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6121-3.1.250pa3yoU7w3GEOx_jpg\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6121-3.1.250pa3yoU7w3GEOx_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6121-3.1.250pa3yoU7w3GEOx_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid6121-2_jpg</o-dd:uid></o-ex:context><o-ex:inherit><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">sid6121-1</o-dd:uid></o-ex:context></o-ex:inherit><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">MVBdKSSAvI1urckJ2TR/DhnPdoM=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>9itQH7w8fhO3NCQLkadzjPjj1y2sCY+w</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-20T06:28:46Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>K/cVzd4SNnZ5MwfbANudetfv/oDciDxOIWjZhE0Yr+OoQ560k8VBWA5xhPmljV2rc6dD+CTrMG7CqQMWJHUL8cDweg31Q+TLT/19Hn0FRp3zUcNWr73bg5geAxsi5rXStCm+0wNmzgOauswRQquzmXLgOkoJXDXjLYh4KET/vZ3JBb8q/JGoRfJoV11b++QBIkXMek4n4/FbkzNWYFccLL+twx+J/oQh</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6121-3.1.250pa3yoU7w3GEOx_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>UNSak/fi53ho5KNY93Glp+Md5oU=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">+QQdZNnVtj8KiKb/uJ/ps7MgmuI=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* ParentRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6121-1.1.iLmQBdzKyztHZpxk_jpg\" stateful=\"true\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6121-1.1.iLmQBdzKyztHZpxk_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6121-1.1.iLmQBdzKyztHZpxk_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">sid6121-1</o-dd:uid></o-ex:context></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:count>2</o-dd:count>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-20T06:28:57Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>KTkSIIEHO5C6u6B6M2xywIZ21Fei/z/rp36qZoowfeiQyeBgqdCYsoG/17w4mXPFp6/AlB9iV7tGAZtJW2dXGPdEkmVjrGcBgcHBKOzTMtgoe0dNbFQl00JrsxoJQUAauV5f2reRDb0Arp3B0X5VwzIa7k7HnMzTMwet2pTLfAb+mj/WZt9Yeut9bd62QvgeGiuX4ciYBA5iTbvOmfPrZ25E+CP+n1bF</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6121-1.1.iLmQBdzKyztHZpxk_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>sQoLiA+5I+VasH94T733KHUdolo=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">FMHrQl5/YRYslSi/NTwJxOXA1tM=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* InvParentKeyRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6121-1.1.RR79rsNn9EeMAUXw_jpg\" stateful=\"true\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6121-1.1.RR79rsNn9EeMAUXw_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6121-1.1.RR79rsNn9EeMAUXw_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">sid6121-1</o-dd:uid></o-ex:context></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:count>2</o-dd:count>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-21T12:09:47Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>GVBzllI7pln47HTygtbZybgedfLsVjUkYQ1xaUO+FWLrWNh38fyhhM7RRAENMBNtvLYFHGGiS5VguLdDpwKMMQIaFim88cohndiN1Ve/ryf7sPWMVgMFJT8hfA98VH3ohe2hiQi5++3ysnQeJHkXjAfnuLLzR1QUjGbB7pCzzi3lbiKmN6r5krggTlMrtHaxvD78k+WfNtI7VNISIG5ih7FjoTmG68vG</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6121-1.1.RR79rsNn9EeMAUXw_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>Cm54CYsqQPhp1Hx2XhY9YifAQQQ=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">G+u4aG2rP1zCa0p/0LIES9FK+90=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* InvParentIntegrityRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6121-1.1.iLmQBdzKyztHZpxk_jpg\" stateful=\"true\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6121-1.1.iLmQBdzKyztHZpxk_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6121-1.1.iLmQBdzKyztHZpxk_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">sid6121-1</o-dd:uid></o-ex:context></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:count>3</o-dd:count>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-20T06:28:57Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>KTkSIIEHO5C6u6B6M2xywIZ21Fei/z/rp36qZoowfeiQyeBgqdCYsoG/17w4mXPFp6/AlB9iV7tGAZtJW2dXGPdEkmVjrGcBgcHBKOzTMtgoe0dNbFQl00JrsxoJQUAauV5f2reRDb0Arp3B0X5VwzIa7k7HnMzTMwet2pTLfAb+mj/WZt9Yeut9bd62QvgeGiuX4ciYBA5iTbvOmfPrZ25E+CP+n1bF</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6121-1.1.iLmQBdzKyztHZpxk_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>sQoLiA+5I+VasH94T733KHUdolo=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">FMHrQl5/YRYslSi/NTwJxOXA1tM=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* ExpiredRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6093-1.1.IXchHW9dEWzt26Eh_mp3\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6093-1.1.IXchHW9dEWzt26Eh_mp3_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6093-1.1.IXchHW9dEWzt26Eh_mp3</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid6093_mp3</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">3wMeI1OB7OMyM5JCxG5aBHKYN18=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>kUz4bkWkCmmC6HJVioos/p+5AK3YD3vc</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:play xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:datetime>\n              <o-dd:start>2001-01-01T00:00:00Z</o-dd:start>\n              <o-dd:end>2001-12-31T23:59:59Z</o-dd:end>\n            </o-dd:datetime>\n          </o-ex:constraint>\n        </o-dd:play>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-16T10:38:41Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>DrX8S6bvattYjI3DvjyJA+nRB5tiTN3BApxl6U/bhxT+ZZDEiuDlJQClNDUbjL66miW/Ow+nSnv9E64b3TfV/n54b+tT/bvwiyDZCG/Jm+MLmaFXGgnmGvAfVCwDADpdprCN7TGzf8nA9rc43Ijw+up18ZnZMBYOkMgvR8V3X7LC/SwMuF6RNU4eAkRnS8yJ+cmGoJ3tTpgKOnVtUbWCZLnefp808o2o</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6093-1.1.IXchHW9dEWzt26Eh_mp3\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>NrHSgdfz+sNsyY87W5F0bKs9DEA=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">lT73n8B5L93Nqgnr+KHbDRDgbeY=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* InvalidKeyRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6094-2.1.TII2JpOVCTtKMar6_jpg\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6094-2.1.TII2JpOVCTtKMar6_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6094-2.1.TII2JpOVCTtKMar6_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid6094_jpg</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">ITHRqJJV3+NufGePQiUSIFP7xDI=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>v1kSMNc7o7j6TEJe2u2y2gzjUiTKbCrE</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:datetime>\n              <o-dd:start>2005-01-01T00:00:00Z</o-dd:start>		\n              <o-dd:end>2012-12-31T23:59:59Z</o-dd:end>\n            </o-dd:datetime>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-21T08:55:01Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>MLdivbbCt3BIHE0iJwD0gRM9PHv5Gnhz0wDgG/rTzRASg375vuW/r8sQ6cetWcb02zBrpPtT/8BHkPeGWud7YNOqWMXoxXZMyFWeUYLiXHjA7BULYC7ZVCGhYxg3E8OnFlxdRuFZtsBhdbLijNnIlQUx8cw7v8cVWntl1eGyUeyEbcMO1ODmM9hSrk2+xbVvYnKzDdNSAeGLgqllsBQmNpkEjEhjAqDq</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6094-2.1.TII2JpOVCTtKMar6_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>52Kl2tf4WQurC6VFQgx5bH7MHAM=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">QcTDxErw1e9RP9RNLX8VkHMKZlw=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* TwoRestrRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6108-3.1.WN4P2HzMjyMi6k6c_jpg\" stateful=\"true\" version=\"1.0\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6108-3.1.WN4P2HzMjyMi6k6c_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.0</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6108-3.1.WN4P2HzMjyMi6k6c_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid6108_jpg</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">Yu5b6N9kpDmeM6FgnihZExMdKJY=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>PlSotHQKcN7ioeYIqR13iVyqUX4Ad+QU</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:count>555</o-dd:count> \n            <o-dd:datetime> \n              <o-dd:start>2000-12-31T23:59:59Z</o-dd:start>\n              <o-dd:end>2001-12-31T23:59:59Z</o-dd:end>\n            </o-dd:datetime>\n            <o-dd:interval>P0DT0H2M0S</o-dd:interval> \n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-27T09:27:03Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>R1Fs700Xp0zpU7FylP5SRwA/oP0pdm7B6XPmYYb8LOn2tppgiCEAJGVEE0MhQ/Tl1PCHoqpPWocf4UHc6THxxMbMTu1rCqH2wKaku17iNIT22HHefcsloyL5XkNcs8V3bs2UsAdEN0+DShMybuIU6vhkO0fts4dldTvfDoDsH2fsmOlOnEXeo5/I/DC9YIZDRP849v7NVtXpa4xEh5gtgpvU0U0bR3mK</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6108-3.1.WN4P2HzMjyMi6k6c_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>dzUkzbdCoda87WBqGPH0Tt3djMA=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">k/S48IjyleEUZeBUh6owSjYP4P0=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* InvIntegrityRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6093-2.1.faQAtIqXh6jzg03l_jpg\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6093-2.1.faQAtIqXh6jzg03l_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6093-2.1.faQAtIqXh6jzg03l_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">cid:cid6093_jpg</o-dd:uid></o-ex:context><o-ex:digest><ds:DigestMethod xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">Y6NHh4Y9GJKYM0jgEOb2CMinsxI=</ds:DigestValue></o-ex:digest><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>0XwT2hGDyxWR5LIHqjYhHsO5jgEEj5pd</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:datetime>\n              <o-dd:start>2005-01-01T00:00:00Z</o-dd:start>		\n              <o-dd:end>2013-12-31T23:59:59Z</o-dd:end>\n            </o-dd:datetime>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-16T08:04:12Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>Wnnihf3AR6oAlyFTK1K3+YRECsAX5fzWrigU/UPKi4jlyJYBk+dChMX31ArMWBWvRXNM9HnioN0KwGgZ2EnMA/kt0gusRRZvV3UpyTR1pina+t5a6woCR7nyXxauNEYHSBqLBfckq5SPu2qVJ7OKV40jlXJ5i35cMmf40BQfMRAo8mDk+T1Oinf5PUjYet8MDUICLJR7Kt2H5E/cO9QFDu3BC5WLrxOR</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6093-2.1.faQAtIqXh6jzg03l_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>ap+RMlXW/l5YYQBMP27F07q4XtY=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">oDdstjQbMtVROb7kOabkDmIMyVk=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

const DxChar_t* GIDRightsXmlStr = "<roap:protectedRO><roap:ro xmlns:roap=\"urn:oma:bac:dldrm:roap-1.0\" id=\"offer6051.1.3OGyukoaHB8H5ic6_jpg\" stateful=\"true\" version=\"1.1\"><riID><keyIdentifier xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" xsi:type=\"roap:X509SPKIHash\"><hash>I94/ovDhizE5m/K6t5f1holSdLM=</hash></keyIdentifier></riID><rights xmlns:o-ex=\"http://odrl.net/1.1/ODRL-EX\" o-ex:id=\"RELoffer6051.1.3OGyukoaHB8H5ic6_jpg_0\">\n    <o-ex:context><o-dd:version xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">2.1</o-dd:version><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">offer6051.1.3OGyukoaHB8H5ic6_jpg</o-dd:uid></o-ex:context>\n    <o-ex:agreement>\n      <o-ex:asset o-ex:id=\"a1\"><o-ex:context><o-dd:uid xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">gid6051</o-dd:uid></o-ex:context><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><xenc:EncryptedKey xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:EncryptionMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>MQCUUbnCvcyO0jMKtIg05BfhMBAdU7p9</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo></o-ex:asset>\n      <o-ex:permission>\n        <o-ex:asset o-ex:idref=\"a1\"></o-ex:asset>\n        <o-dd:display xmlns:o-dd=\"http://odrl.net/1.1/ODRL-DD\">\n          <o-ex:constraint>\n            <o-dd:count>3</o-dd:count>\n          </o-ex:constraint>\n        </o-dd:display>\n      </o-ex:permission>\n    </o-ex:agreement>\n  </rights><timeStamp>2009-04-20T09:18:27Z</timeStamp><encKey Id=\"K_MAC_and_K_REK0\"><xenc:EncryptionMethod xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" Algorithm=\"http://www.rsasecurity.com/rsalabs/pkcs/schemas/pkcs-1#rsaes-kem-kdf2-kw-aes128\"></xenc:EncryptionMethod><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><roap:X509SPKIHash algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"><hash>5WmLIYYmjj6wuhU6X08cfcVI0Jo=</hash></roap:X509SPKIHash></ds:KeyInfo><xenc:CipherData xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\"><xenc:CipherValue>rKsUnOeXDQOcXD3KVYJGsGyvDNwgSiVS1SV/6vqIM820wZ22XWEN7RYpGRc4474q1GfW/n9hT3YxYFuMHfGhCOHgXxr45PnXB1FABwngUm0PJ0EaPaDIj3Vu8qHdvg1QR8YSUjWYri/CrbSE/p+Gws/TjlqAly8Ppw415ipyGQq4vwkPm9QWpBUSlPhtmonhRH/T20xl1JZDXQ8Ss14FYeXACnHtTDa0</xenc:CipherValue></xenc:CipherData></encKey></roap:ro><mac><ds:SignedInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:CanonicalizationMethod><ds:SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\"></ds:SignatureMethod><ds:Reference URI=\"#offer6051.1.3OGyukoaHB8H5ic6_jpg\"><ds:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\"></ds:Transform></ds:Transforms><ds:DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></ds:DigestMethod><ds:DigestValue>3OQVGiSdTuaEoxpmD5UgbcMbXVY=</ds:DigestValue></ds:Reference></ds:SignedInfo><ds:SignatureValue xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\">hJAxA3NEoqA9rTElY6bzk9pBBfk=</ds:SignatureValue><ds:KeyInfo xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\"><ds:RetrievalMethod URI=\"#K_MAC_and_K_REK0\"></ds:RetrievalMethod></ds:KeyInfo></mac></roap:protectedRO>";

